import pytest
import sqlite3

@pytest.fixture()
def some_data():
	return 471

def test_some_data(some_data):
	assert some_data == 471

@pytest.fixture()
def i_tuple():
	return (1, 'foo', 'bar', {'abc': 123})

def test_i_tuple(i_tuple):
	assert i_tuple[3]['abc'] == 123

@pytest.fixture(scope="module")
def database():
	db = sqlite3.connect("file::memory:?cache=shared", uri=True)
	db.execute("CREATE TABLE foo (bar, baz)")
	yield db 
	db.close

def test_insert(database):
 	database.execute("INSERT INTO foo VALUES ('spam', 'ham')")
 	database.commit
 	result = list(database.execute('SELECT * FROM foo'))
 	assert [('spam', 'ham')] == result

